// bergmark - spring 1999 - ITX project

import java.io.*;
import cnrg.itx.*;
import cnrg.itx.signal.*;
import cnrg.itx.ds.*;

public class PrintDirectory extends AbstractSignalingObserver {
   private DesktopSignaling myDS = null;
   private DataOutputStream out = null;                        


   // Default constructor
   public PrintDirectory () {
      // Get a signaling object
      try {
	 myDS = new DesktopSignaling ( this, "adm", "itxds" );
      } catch ( Exception e ) {
	 System.out.println ("Couldn't authenticate because" +
	    e.toString() );
	 System.exit(0);
      }
      System.out.println ("Got a DesktopSignling!");
   }

   // This method writes the ITX directory to disk
   private void generateExtensions (int n) {
      String ext;
      FileOutputStream fs = null;                               
      try {
	 fs = new FileOutputStream("ExtensionList");
	 out = new DataOutputStream ( fs );
      } catch ( Exception e ) {
	 System.out.println ( "\n\nCould not open output file because " +
	    e.toString() );
      }
      for ( int i = 0; i < 10000+n; i++ ) {
	 ext = Integer.toString(i);
	 try {
	    out.writeBytes (ext + ": " +
	       myDS.getDirectory().getID(new Digits(ext)).toString() + "\n" );
	 } catch ( Exception e ) {}
      }
   }

   // This method logs us out
   private void fini () {
      try {
	 out.flush();
	 out.close();
      } catch ( Exception e ) {}
      myDS.logout();
   }

   // Main program
   public static void main (String[] args) {
      PrintDirectory me = new PrintDirectory ();
      me.generateExtensions(30);
      me.fini();            
      }
}
